/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.SourceStat;
import cds.aladin.SourceTag;
import cds.aladin.ViewSimple;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;

public class SourceInfo
extends SourceTag {
    protected static Legende legende = SourceInfo.createLegende();
    protected int dw;
    protected int dh;
    private static final String C = "|";

    protected static Legende createLegende() {
        if (legende != null) {
            return legende;
        }
        legende = Legende.adjustDefaultLegende(legende, 3, new String[]{"_RAJ2000", "_DEJ2000", "ID", "s_region", "Origin", "RA (ICRS)", "DE (ICRS)", "Count", "Sum", "Sigma", "Min", "Avg", "Max", "Area"});
        legende = Legende.adjustDefaultLegende(legende, 6, new String[]{"double", "double", "char", "char", "char", "char", "char", "integer", "double", "double", "double", "double", "double", "double"});
        legende = Legende.adjustDefaultLegende(legende, 5, new String[]{"deg", "deg", "", "", "", "\"h:m:s\"", "\"h:m:s\"", "pixel", "", "", "", "", "", "arcmin^2"});
        legende = Legende.adjustDefaultLegende(legende, 10, new String[]{"10", "10", "6", "5", "10", "10", "10", "6", "8", "6", "6", "6", "6", "6"});
        legende = Legende.adjustDefaultLegende(legende, 12, new String[]{"6", "6", "", "", "", "4", "5", "2", "4", "4", "4", "4", "4", "4"});
        legende = Legende.adjustDefaultLegende(legende, 4, new String[]{"RA", "DEC", "Identifier", "Field of View", "Reference image", "Right ascension", "Declination", "Pixel count", "Sum of pixel values", "Median of the distribution", "Minimum value", "Average value", "Maximum value", "Area (pixels)"});
        legende = Legende.adjustDefaultLegende(legende, 7, new String[]{"pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "meta.id;meta.main", "", "", "pos.eq.ra", "pos.eq.dec", "", "", "", "", "", "", ""});
        SourceInfo.legende.name = "Pixel statistics";
        SourceInfo.hideRADECLegende(legende);
        return legende;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        return super.draw(g, v, dx, dy);
    }

    protected SourceInfo(Plan plan) {
        super(plan);
    }

    protected SourceInfo(SourceStat s) {
        super(s.plan);
        this.id = "Circle " + SourceInfo.nextIndice();
        this.setInfo(s);
    }

    protected SourceInfo(Ligne s) {
        super(s.plan);
        this.id = "Polygon " + SourceInfo.nextIndice();
        this.setInfo(s);
    }

    protected SourceInfo(Plan plan, ViewSimple v, Coord c, String id) {
        super(plan, v, c, id);
    }

    protected SourceInfo(Plan plan, ViewSimple v, double x, double y, String id) {
        super(plan, v, x, y, id);
    }

    private void setInfo(Obj s) {
        String fov;
        this.raj = s.raj;
        this.dej = s.dej;
        this.setLeg(legende);
        double[] stat = null;
        int z = -1;
        this.planBase = this.plan.aladin.calque.getPlanBase();
        String nomPlan = this.planBase.label;
        if (this.planBase.isCube()) {
            z = (int)this.planBase.getZ();
            int d = 1 + z;
            nomPlan = nomPlan + "/" + d;
        }
        try {
            stat = s.getStatistics(this.planBase, z);
        }
        catch (Exception e) {
            stat = null;
        }
        String cnt = stat == null ? " " : "" + stat[0];
        String tot = stat == null ? " " : "" + stat[1];
        String avg = stat != null && stat[0] > 0.0 ? "" + stat[1] / stat[0] : " ";
        String sig = stat == null ? " " : "" + stat[2];
        String surf = stat == null ? " " : "" + stat[3] * 3600.0;
        String min = stat == null ? " " : "" + stat[4];
        String max = stat == null ? " " : "" + stat[5];
        Coord c = new Coord(s.raj, s.dej);
        if (this.planBase instanceof PlanBG) {
            PlanBG pbg = (PlanBG)this.planBase;
            int orderFile = pbg.getOrder();
            nomPlan = nomPlan + " (HiPS order " + orderFile + ")";
        }
        String string = s instanceof SourceStat ? ((SourceStat)s).getFoV() : (fov = s instanceof Ligne ? ((Ligne)s).getFoV() : null);
        if (fov != null) {
            this.setFootprint(fov);
            this.setIdxFootprint(3);
        }
        this.info = "<&_A|Phots>\t" + this.raj + "\t" + this.dej + "\t" + this.id + "\t" + fov + "\t" + nomPlan + "\t" + c.getRA() + "\t" + c.getDE() + "\t" + cnt + "\t" + tot + "\t" + sig + "\t" + min + "\t" + avg + "\t" + max + "\t" + surf;
    }

    @Override
    public String getObjType() {
        return "Phot";
    }

    void setD() {
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        this.dw = m.stringWidth(this.id) + 4;
        this.dh = HF;
    }
}

